/*  program ArduCalibrator.ino for the ADS1115, 16 bit 4 ch ADC
 a single differential input (A0,A1), Ch0 6144 mV (5000 generated)
 read the  precision voltage source
 uses an Arduino Pro Mini, LCD 16x2 display
 Giovanni Carrera 23/11/2022 with calibration
 */
#include <Wire.h>
#include<ADS1115_WE.h>
#include <LiquidCrystal.h>
ADS1115_WE adc = ADS1115_WE();// uses Wire / ADC Address = 0x48

// LCD pins
#define rs 7
#define en 6
#define d4 5
#define d5 4
#define d6 A2
#define d7 A3
// initialize the library by associating any needed LCD interface pin
LiquidCrystal lcd(rs, en, d4, d5, d6, d7);

#define Alert 2  // AD Alert pin
const unsigned long deltat_ms = 500;
unsigned long cms, pms;
float Ch0,Ch1;

void setup(){
  Wire.begin();
  //Serial.begin(115200);
  pinMode(Alert,INPUT);
  // set up the LCD's number of columns and rows:
  lcd.begin(16, 2);
  lcd.print(F("ArduCalibrator"));
  lcd.setCursor(0, 1);// print on the second row
  lcd.print(F("GCar V231122"));
  delay(2000);
  if(!adc.init()){
    lcd.setCursor(0, 1);
    lcd.print(F("No ADS1115 found"));
    while( true );// ends here
  }
  adc.setVoltageRange_mV(ADS1115_RANGE_6144); // 6144 mV input range
  LCDprintLine("PRECISION SOURCE", 0);
}

void loop() {
  cms = millis();
  // checks if passed deltat milliseconds
  if(cms - pms > deltat_ms) {   // period timebase
	  pms = cms;// update pms
    Ch0 = readChannel(ADS1115_COMP_0_1);// Ch0 differential A0(+) with A1(-)
    Ch0 = readChannel(ADS1115_COMP_0_1);// repetita iuvant
    printData();      
  }
}

/************************** Functions **************************/
float readChannel(ADS1115_MUX channel) {
  float mV = 0.0;
  adc.setCompareChannels(channel);
  adc.startSingleMeasurement();
  while(adc.isBusy()){}
  mV = adc.getResult_mV(); // alternative: getResult_V
  return mV;
}

void LCDprintLine(String text, byte line){
const char bline[17] = "                ";// blank line  
   lcd.setCursor(0, line);
   lcd.print(bline);// clear the second row
   lcd.setCursor(0, line);
   lcd.print(text);// print text
}

void printData(){
  float voltage;
  voltage = Ch0*1.000515+0.022;// calibrated and result in millivolts
  if (voltage < 0) voltage = 0;
  String data0 = String(voltage,2) + "[mV]";
  LCDprintLine(data0, 1);
}
